#
#-------------------------------------------------------------
#
#	ROBOTRAN - Version 6.6 (build : february 22, 2008)
#
#	Copyright 
#	Universite catholique de Louvain 
#	Departement de Mecanique 
#	Unite de Production Mecanique et Machines 
#	2, Place du Levant 
#	1348 Louvain-la-Neuve 
#	http://www.robotran.be// 
#
#	==> Generation Date : Mon Jan 27 11:51:33 2020
#
#	==> Project name : pendulum_spring_python
#	==> using XML input file 
#
#	==> Number of joints : 4
#
#	==> Function : F 6 : Sensors Kinematical Informations (sens) 
#	==> Flops complexity : 54
#
#	==> Generation Time :  0.000 seconds
#	==> Post-Processing :  0.000 seconds
#
#-------------------------------------------------------------
#
import numpy as np  

def sensor(sens, s, isens):

  
  q = s.q
  qd = s.qd
  qdd = s.qdd

# === begin imp_aux === 

# === end imp_aux === 

# ===== BEGIN task 0 ===== 
 
# Sensor Kinematics 



# = = Block_0_0_0_0_0_1 = = 
 
# Augmented Joint Position Vectors   

  Dz23 = q[2]+s.dpt[3,3]
 
# Trigonometric Variables  

  C1 = np.cos(q[1])
  S1 = np.sin(q[1])

# = = Block_0_0_0_0_0_2 = = 
 
# Trigonometric Variables  

  C3 = np.cos(q[3])
  S3 = np.sin(q[3])
  C4 = np.cos(q[4])
  S4 = np.sin(q[4])

# = = Block_0_0_0_4_0_2 = = 
 
# Trigonometric Variables  

  S3p4 = C3*S4+S3*C4
  C3p4 = C3*C4-S3*S4

# ====== END Task 0 ====== 

# ===== BEGIN task 1 ===== 
 
# Sensor Kinematics 


 
# 
  if(isens==1): 


# = = Block_1_0_0_1_1_0 = = 
 
# Symbolic Outputs  

    sens.R[1,1] = C1
    sens.R[1,3] = -S1
    sens.R[2,2] = (1.0)
    sens.R[3,1] = S1
    sens.R[3,3] = C1
    sens.OM[2] = qd[1]
    sens.OMP[2] = qdd[1]
 
# 
  elif(isens==2): 


# = = Block_1_0_0_2_0_1 = = 
 
# Sensor Kinematics 


    RLcp1_12 = Dz23*S1
    RLcp1_32 = Dz23*C1
    ORcp1_12 = RLcp1_32*qd[1]
    ORcp1_32 = -RLcp1_12*qd[1]
    VIcp1_12 = ORcp1_12+qd[2]*S1
    VIcp1_32 = ORcp1_32+qd[2]*C1
    ACcp1_12 = RLcp1_32*qdd[1]+qdd[2]*S1+qd[1]*(ORcp1_32+(2.0)*qd[2]*C1)
    ACcp1_32 = -(RLcp1_12*qdd[1]-qdd[2]*C1+qd[1]*(ORcp1_12+(2.0)*qd[2]*S1))

# = = Block_1_0_0_2_1_0 = = 
 
# Symbolic Outputs  

    sens.P[1] = RLcp1_12
    sens.P[3] = RLcp1_32
    sens.R[1,1] = C1
    sens.R[1,3] = -S1
    sens.R[2,2] = (1.0)
    sens.R[3,1] = S1
    sens.R[3,3] = C1
    sens.V[1] = VIcp1_12
    sens.V[3] = VIcp1_32
    sens.OM[2] = qd[1]
    sens.A[1] = ACcp1_12
    sens.A[3] = ACcp1_32
    sens.OMP[2] = qdd[1]
 
# 
  elif(isens==3): 


# = = Block_1_0_0_3_1_0 = = 
 
# Symbolic Outputs  

    sens.P[1] = s.dpt[1,2]
    sens.R[1,1] = C3
    sens.R[1,3] = -S3
    sens.R[2,2] = (1.0)
    sens.R[3,1] = S3
    sens.R[3,3] = C3
    sens.OM[2] = qd[3]
    sens.OMP[2] = qdd[3]
 
# 
  elif(isens==4): 


# = = Block_1_0_0_4_0_2 = = 
 
# Sensor Kinematics 


    RLcp3_14 = s.dpt[3,6]*S3
    RLcp3_34 = s.dpt[3,6]*C3
    POcp3_14 = RLcp3_14+s.dpt[1,2]
    OMcp3_24 = qd[3]+qd[4]
    ORcp3_14 = RLcp3_34*qd[3]
    ORcp3_34 = -RLcp3_14*qd[3]
    OPcp3_24 = qdd[3]+qdd[4]
    ACcp3_14 = ORcp3_34*qd[3]+RLcp3_34*qdd[3]
    ACcp3_34 = -(ORcp3_14*qd[3]+RLcp3_14*qdd[3])

# = = Block_1_0_0_4_1_0 = = 
 
# Symbolic Outputs  

    sens.P[1] = POcp3_14
    sens.P[3] = RLcp3_34
    sens.R[1,1] = C3p4
    sens.R[1,3] = -S3p4
    sens.R[2,2] = (1.0)
    sens.R[3,1] = S3p4
    sens.R[3,3] = C3p4
    sens.V[1] = ORcp3_14
    sens.V[3] = ORcp3_34
    sens.OM[2] = OMcp3_24
    sens.A[1] = ACcp3_14
    sens.A[3] = ACcp3_34
    sens.OMP[2] = OPcp3_24



# ====== END Task 1 ====== 

  

